// AtmoduinoV2 by NevCairiel, based on RickDB Atmoduino V1

#include <FastLED.h>

// Set the number of leds in the strip.
#define NUM_LEDS 112
//lr=20, ou=36 = 112
#define LED_START 56

// type of the LED controller
//#define LED_TYPE WS2801
#define LED_TYPE WS2812

// data and clock pins
#define DATA_PIN 4 //11
//#define CLOCK_PIN 13

CRGB leds[NUM_LEDS];

bool skip=false;

void setup(){
  Serial.begin(115200);
  pinMode(13,OUTPUT);
  digitalWrite(13,HIGH);
  
  //sanity check delay - allows reprogramming if accidently blowing power w/leds
  delay(3000);
  digitalWrite(13,LOW);
   
  //Change this to match your led strip
  
      // Uncomment one of the following lines for your leds arrangement.
      // FastLED.addLeds<TM1803, DATA_PIN, RGB>(leds, NUM_LEDS);
      // FastLED.addLeds<TM1804, DATA_PIN, RGB>(leds, NUM_LEDS);
      // FastLED.addLeds<TM1809, DATA_PIN, RGB>(leds, NUM_LEDS);
      // FastSPI_LED2.addLeds<WS2811, DATA_PIN, GRB>(leds+18, NUM_LEDS/3);
      // FastLED.addLeds<WS2811, 8, RGB>(leds + 225, NUM_LEDS/4);
      //FastLED.addLeds<WS2812, DATA_PIN, RGB>(leds, NUM_LEDS);
      FastLED.addLeds<WS2812, DATA_PIN, GRB>(leds, NUM_LEDS);
      // FastLED.addLeds<WS2812B, DATA_PIN, RGB>(leds, NUM_LEDS);
      // FastLED.addLeds<NEOPIXEL, DATA_PIN, RGB>(leds, NUM_LEDS);
      // FastLED.addLeds<WS2811_400, DATA_PIN, RGB>(leds, NUM_LEDS);
      // FastLED.addLeds<UCS1903, DATA_PIN, RGB>(leds, NUM_LEDS);

       //FastLED.addLeds<WS2801, RGB>(leds, NUM_LEDS);
      // FastLED.addLeds<SM16716, RGB>(leds, NUM_LEDS);
      // FastLED.addLeds<LPD8806, RGB>(leds, NUM_LEDS);

      //FastLED.addLeds<WS2801, DATA_PIN, CLOCK_PIN, RGB>(leds, NUM_LEDS);
      // FastLED.addLeds<SM16716, DATA_PIN, CLOCK_PIN, RGB>(leds, NUM_LEDS);
      // FastLED.addLeds<LPD8806, DATA_PIN, CLOCK_PIN, RGB>(leds, NUM_LEDS);
  setupLEDs();
  clearLeds();
}

int readByte(){
  uint16_t maxwait=0;
  while (Serial.available() == 0){ /* wait for data */ 
    maxwait++;
    if (maxwait>=65535){
      digitalWrite(13,!digitalRead(13));
      skip=true;
      return 0x01; //return something
    }
  }
  return Serial.read();
}
int readByteNoSkip(){
  uint16_t maxwait=0;
  while (Serial.available() == 0){ /* wait for data */ }
  return Serial.read();
}

void clearLeds(){
  for(int dot = 0; dot < NUM_LEDS; dot++){
    leds[dot] = CRGB::Black; 
  };
  FastLED.show();
}

// shows colored LEDs for 500ms then blanks out ready to go
void setupLEDs()
{
memset(leds,20, sizeof(leds));
FastLED.show();
delay(500);
memset(leds,0, sizeof(leds));
FastLED.show();
}

void loop() { 
  skip=false;
  if(readByteNoSkip() == 0xFF){ //D7
    //digitalWrite(13,HIGH);
    if(readByte() == 0x00 && !skip){ //EE
      if(readByte() == 0x00 && !skip){ //23
        //digitalWrite(13,!digitalRead(13));
        int channels = readByte();
        for(int dot = 0; dot < channels  && !skip; dot++){
          int _dot=(dot+LED_START)%NUM_LEDS; //because atmowin starts at top left (goes cw)
          leds[_dot].r = readByte();
          leds[_dot].g = readByte();
          leds[_dot].b = readByte();
        }
        if (!skip){
          FastLED.show();
        }
      }
    }
    //digitalWrite(13,LOW);
  }
}

