/*
 * Decompiled with CFR 0.152.
 */
package c41inverter;

import c41inverter.LGS;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class ColorCorrection {
    double[] R;
    double[] r;
    double[] G;
    double[] g;
    double[] B;
    double[] b;
    double[] xr;
    double[] xg;
    double[] xb;

    public ColorCorrection(double[] pR, double[] pr, double[] pG, double[] pg, double[] pB, double[] pb) {
        this.R = pR;
        this.r = pr;
        this.G = pG;
        this.g = pg;
        this.B = pB;
        this.b = pb;
        this.calculateCurves();
    }

    public void calculateCurves() {
        this.xr = this.calculateCurve(this.R, this.r);
        this.xg = this.calculateCurve(this.G, this.g);
        this.xb = this.calculateCurve(this.B, this.b);
    }

    private double[] calculateCurve(double[] U, double[] u) {
        System.out.println("Setting up matrix");
        double[][] A = this.makeMatrix(u);
        double[] x = LGS.solve(A, U);
        System.out.println("[x0,x1,..,xn] = " + Arrays.toString(x));
        return x;
    }

    private double[][] makeMatrix(double[] u) {
        double[][] A = new double[u.length][u.length];
        int row = 0;
        while (row < u.length) {
            A[row][0] = 1.0;
            int column = 0;
            while (column < u.length - 1) {
                A[row][column + 1] = Math.pow(u[row], column + 1);
                ++column;
            }
            System.out.println(Arrays.toString(A[row]));
            ++row;
        }
        return A;
    }

    public double getProcessedValue(double[] px, double pu) {
        double y = 0.0;
        int i = 0;
        while (i < px.length) {
            y += px[i] * Math.pow(pu, i);
            ++i;
        }
        return y;
    }

    public BufferedImage processImage(BufferedImage sourceImage) {
        return this.processImage(sourceImage, false);
    }

    public BufferedImage processImage(BufferedImage sourceImage, boolean pshowOverUnderExposure) {
        BufferedImage resultImage = ColorCorrection.deepCopy(sourceImage);
        this.calculateCurves();
        int y = 0;
        while (y < sourceImage.getHeight()) {
            if (y % (sourceImage.getHeight() / 10) == 0) {
                System.out.print("|");
            }
            int x = 0;
            while (x < sourceImage.getWidth()) {
                Color pixelColor = new Color(sourceImage.getRGB(x, y));
                Color pixelColorProcessed = this.getProcessedColor(pixelColor, pshowOverUnderExposure);
                resultImage.setRGB(x, y, pixelColorProcessed.getRGB());
                ++x;
            }
            ++y;
        }
        return resultImage;
    }

    public Color getProcessedColor(Color pixelColor) {
        return this.getProcessedColor(pixelColor, false);
    }

    public Color getProcessedColor(Color pixelColor, boolean pshowOverUnderExposure) {
        int oe_lowThres = 5;
        int oe_highThres = 250;
        double r = (double)pixelColor.getRed() / 255.0;
        double g = (double)pixelColor.getGreen() / 255.0;
        double b = (double)pixelColor.getBlue() / 255.0;
        r = this.getProcessedValue(this.xr, r) * 255.0;
        g = this.getProcessedValue(this.xg, g) * 255.0;
        b = this.getProcessedValue(this.xb, b) * 255.0;
        if (pshowOverUnderExposure) {
            if ((r + g + b) / 3.0 <= (double)oe_lowThres) {
                r = 255.0;
                g = 255.0;
                b = 255.0;
            } else if ((r + g + b) / 3.0 >= (double)oe_highThres) {
                r = 0.0;
                g = 0.0;
                b = 0.0;
            }
        }
        if (r < 0.0) {
            r = 0.0;
        } else if (r > 255.0) {
            r = 255.0;
        }
        if (g < 0.0) {
            g = 0.0;
        } else if (g > 255.0) {
            g = 255.0;
        }
        if (b < 0.0) {
            b = 0.0;
        } else if (b > 255.0) {
            b = 255.0;
        }
        return new Color((int)r, (int)g, (int)b);
    }

    static BufferedImage deepCopy(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public String getIMfx(int pdecimals) {
        this.calculateCurves();
        String pre = "convert ./tmp/_%%f";
        String post = " ./out/%%f";
        String red = " -channel R -fx \"";
        String green = " -channel G -fx \"";
        String blue = " -channel B -fx \"";
        red = this.parseCoefficients(red, this.xr, pdecimals);
        green = this.parseCoefficients(green, this.xg, pdecimals);
        blue = this.parseCoefficients(blue, this.xb, pdecimals);
        return String.valueOf(pre) + red + green + blue + post;
    }

    private String parseCoefficients(String current, double[] xcurrent, int pdecimals) {
        int i = 0;
        while (i < xcurrent.length) {
            if (i != 0) {
                current = String.valueOf(current) + "+";
            }
            int ucount = 0;
            while (ucount < i) {
                current = String.valueOf(current) + "u*";
                ++ucount;
            }
            current = String.valueOf(current) + (double)((int)Math.round(xcurrent[i] * Math.pow(10.0, pdecimals))) * 1.0 / Math.pow(10.0, pdecimals);
            ++i;
        }
        return String.valueOf(current) + "\"";
    }
}

