/*
 * Decompiled with CFR 0.152.
 */
package c41inverter;

import c41inverter.ColorCorrection;
import c41inverter.ColorPoint;
import c41inverter.ToolFrame;
import c41inverter.Window;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;
import javax.imageio.ImageIO;

public class Controller {
    ColorCorrection cc;
    Window window;
    ToolFrame toolframe;
    int mouseDown = 0;
    MouseEvent mouseEvent;
    MouseEvent lastmouseEvent;
    private LinkedList<ColorPoint> colorPoints;
    String IMAGEMAGICK_DIR = "";
    private MyMouseListener myMouseListener = new MyMouseListener();

    public static void main(String[] args) {
        new Controller();
    }

    public Controller() {
        this.colorPoints = new LinkedList();
        this.colorPoints.add(new ColorPoint(new Color(0, 0, 0), new Color(0, 0, 0)));
        this.colorPoints.add(new ColorPoint(new Color(255, 255, 255), new Color(255, 255, 255)));
        this.window = new Window(250, 200, 800, 600, "Preview", this.myMouseListener);
        this.toolframe = new ToolFrame(5, 200, 240, 430, "Tools", this, this.colorPoints);
        this.loadConfig();
        this.loadAsCalibrationimage("grauverlauf_filmtest.png", false);
    }

    public void enableColorCorrection() {
        this.window.applyColorCorrection(this.makeColorCorrection(this.colorPoints));
        System.out.println("CC enabled");
    }

    public void disableColorCorrection() {
        this.window.applyColorCorrection(null);
        System.out.println("CC disabled");
    }

    public void enableOverUnderExposureDisplay() {
        this.window.setOverUnderExposureDisplay(true);
        System.out.println("Over/Underexposure display enabled");
    }

    public void disableOverUnderExposureDisplay() {
        this.window.setOverUnderExposureDisplay(false);
        System.out.println("Over/Underexposure display disabled");
    }

    public ColorCorrection makeColorCorrection(LinkedList<ColorPoint> pcp) {
        int nodcp = this.numberOfDefinedColorPoints(pcp);
        double[] R = new double[nodcp];
        double[] r = new double[nodcp];
        double[] G = new double[nodcp];
        double[] g = new double[nodcp];
        double[] B = new double[nodcp];
        double[] b = new double[nodcp];
        int i = 0;
        while (i < pcp.size()) {
            ColorPoint _cp = pcp.get(i);
            if (_cp.isDefined()) {
                R[i] = (double)_cp.getCorrectedColor().getRed() / 255.0;
                G[i] = (double)_cp.getCorrectedColor().getGreen() / 255.0;
                B[i] = (double)_cp.getCorrectedColor().getBlue() / 255.0;
                r[i] = (double)_cp.getSelectedColor().getRed() / 255.0;
                g[i] = (double)_cp.getSelectedColor().getGreen() / 255.0;
                b[i] = (double)_cp.getSelectedColor().getBlue() / 255.0;
            }
            ++i;
        }
        ColorCorrection cc = new ColorCorrection(R, r, G, g, B, b);
        return cc;
    }

    public int numberOfDefinedColorPoints(LinkedList<ColorPoint> pcp) {
        int count = 0;
        int i = 0;
        while (i < pcp.size()) {
            if (pcp.get(i).isDefined()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public BufferedImage loadImage(String pfilename) {
        BufferedImage img = null;
        try {
            img = ImageIO.read(new File(pfilename));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }

    public void loadAsCalibrationimage(String pfilename) {
        this.loadAsCalibrationimage(pfilename, true);
    }

    public void loadAsCalibrationimage(String pfilename, boolean resize) {
        if (resize) {
            String newpfilename = "preview.jpg";
            Object[] imagemagick_preview = new String[]{String.valueOf(this.IMAGEMAGICK_DIR) + "convert", pfilename, "-resize", this.window.getWindowWidth() + "x" + this.window.getWindowHeight(), "-filter", "Gaussian", newpfilename};
            System.out.println("Resizing: " + Arrays.toString(imagemagick_preview));
            ProcessBuilder pb = new ProcessBuilder((String[])imagemagick_preview);
            pb.redirectErrorStream(true);
            try {
                Process p = pb.start();
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
                System.out.println(p.waitFor());
            }
            catch (Exception e) {
                System.err.println("Exception");
                System.err.println(e.getMessage());
            }
            pfilename = newpfilename;
        }
        BufferedImage calibrationImage = this.loadImage(pfilename);
        this.window.setImage(calibrationImage);
    }

    public void exportCurve(String pfile, int pdecimals) {
        ColorCorrection cc = this.makeColorCorrection(this.colorPoints);
        String imcmd = cc.getIMfx(pdecimals);
        System.out.println("Writing batch file to " + pfile);
        System.out.println(imcmd);
        String preFile = "pre.sh";
        String postFile = "post.sh";
        if (System.getProperty("os.name").startsWith("Windows")) {
            System.out.println("Detected Windows");
            preFile = "pre.cmd";
            postFile = "post.cmd";
        } else if (System.getProperty("os.name").startsWith("Linux")) {
            System.out.println("Detected Linux");
            preFile = "pre.sh";
            postFile = "post.sh";
        } else {
            System.out.println("OS not supported?");
        }
        System.out.println("->Using " + preFile + " and " + postFile);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(pfile)));
            String currentLine = "";
            BufferedReader br = new BufferedReader(new FileReader(new File(preFile)));
            while ((currentLine = br.readLine()) != null) {
                bw.write(currentLine);
                bw.newLine();
            }
            bw.write(imcmd);
            bw.newLine();
            br.close();
            br = new BufferedReader(new FileReader(new File(postFile)));
            while ((currentLine = br.readLine()) != null) {
                bw.write(currentLine);
                bw.newLine();
            }
            bw.flush();
            bw.close();
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Couldnt write file " + pfile);
            System.err.println("Check if files pre.cmd and post.cmd exist!");
        }
    }

    public void loadConfig() {
        System.out.println("loading config:");
        String currentLine = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(new File("config.cfg")));
            while ((currentLine = br.readLine()) != null) {
                String[] linesplit = currentLine.split("::");
                System.out.println(String.valueOf(linesplit[0]) + " -> " + linesplit[1]);
                if (linesplit[0].equals("loaddir")) {
                    this.toolframe.setLastFileDirectory(new File(linesplit[1]));
                    continue;
                }
                if (!linesplit[0].equals("imagemagick")) continue;
                this.IMAGEMAGICK_DIR = linesplit[1];
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Couldnt load config file 'config.cfg'");
        }
    }

    public void saveConfig() {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File("config.cfg")));
            bw.write("loaddir::" + this.toolframe.getLastFileDirectory().getAbsolutePath());
            bw.newLine();
            bw.write("imagemagick::" + this.IMAGEMAGICK_DIR);
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Couldnt save config file 'config.cfg'");
        }
    }

    public void test() {
        double[] R = new double[]{0.0, 0.5, 1.0};
        double[] r = new double[]{0.761, 0.49, 0.373};
        this.cc.calculateCurves();
    }

    public class MyMouseListener
    implements MouseListener,
    MouseMotionListener {
        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Controller.this.window.setMousePos(null);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Controller.this.mouseDown = e.getButton();
            Controller.this.mouseEvent = e;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Controller.this.mouseDown = 0;
            Controller.this.lastmouseEvent = e;
            Controller.this.window.setSelectionRect(null, null);
            Point a = new Point(Controller.this.mouseEvent.getX(), Controller.this.mouseEvent.getY());
            Point b = new Point(Controller.this.lastmouseEvent.getX(), Controller.this.lastmouseEvent.getY());
            Color avgcolor = Controller.this.window.getAverageRectColor(a, b);
            if (Controller.this.toolframe.getColorPointsList_selectedIndex() >= 0 && Controller.this.toolframe.getColorPointsList_selectedIndex() < Controller.this.colorPoints.size()) {
                ColorPoint ccp = (ColorPoint)Controller.this.colorPoints.get(Controller.this.toolframe.getColorPointsList_selectedIndex());
                if (avgcolor != null) {
                    if (e.getButton() == 1) {
                        ccp.setSelectedColor(avgcolor);
                        if (ccp.getCorrectedColor() == null && Controller.this.numberOfDefinedColorPoints(Controller.this.colorPoints) >= 2) {
                            ColorCorrection _cc = Controller.this.makeColorCorrection(Controller.this.colorPoints);
                            Color pixelColorProcessed = _cc.getProcessedColor(avgcolor);
                            int v = (pixelColorProcessed.getRed() + pixelColorProcessed.getGreen() + pixelColorProcessed.getBlue()) / 3;
                            System.out.println("avgcolor:" + avgcolor.getRed());
                            System.out.println("pixelColorProcessed:" + pixelColorProcessed.getRed());
                            System.out.println("v:" + v);
                            ccp.setCorrectedColor(new Color(v, v, v));
                        }
                    } else if (e.getButton() == 3) {
                        ccp.setCorrectedColor(avgcolor);
                    }
                } else {
                    System.err.println("No color has been picked");
                }
            } else {
                System.err.println("No item was selected");
            }
            Controller.this.toolframe.updateColorPointsList();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Controller.this.window.setSelectionRect(Controller.this.mouseEvent.getPoint(), e.getPoint());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Controller.this.window.setMousePos(e.getPoint());
        }
    }
}

