/*
 * Decompiled with CFR 0.152.
 */
package c41inverter;

public class LGS {
    static int[] pivot(double[][] A) {
        int n = A.length;
        int[] pivot = new int[n];
        int j = 0;
        while (j < n - 1) {
            double max = Math.abs(A[j][j]);
            int imax = j;
            int i = j + 1;
            while (i < n) {
                if (Math.abs(A[i][j]) > max) {
                    max = Math.abs(A[i][j]);
                    imax = i;
                }
                ++i;
            }
            double[] h = A[j];
            A[j] = A[imax];
            A[imax] = h;
            pivot[j] = imax;
            int i2 = j + 1;
            while (i2 < n) {
                double f = -A[i2][j] / A[j][j];
                int k = j + 1;
                while (k < n) {
                    double[] dArray = A[i2];
                    int n2 = k;
                    dArray[n2] = dArray[n2] + f * A[j][k];
                    ++k;
                }
                A[i2][j] = -f;
                ++i2;
            }
            ++j;
        }
        return pivot;
    }

    public static double[] solve(double[][] A, double[] b) {
        double[][] B = (double[][])A.clone();
        double[] x = (double[])b.clone();
        int[] pivot = LGS.pivot(B);
        int n = B.length;
        int i = 0;
        while (i < n - 1) {
            double h = b[pivot[i]];
            b[pivot[i]] = b[i];
            b[i] = h;
            ++i;
        }
        int j = 0;
        while (j < n) {
            x[j] = b[j];
            int i2 = 0;
            while (i2 < j) {
                int n2 = j;
                x[n2] = x[n2] - B[j][i2] * x[i2];
                ++i2;
            }
            ++j;
        }
        j = n - 1;
        while (j >= 0) {
            int k = j + 1;
            while (k < n) {
                int n3 = j;
                x[n3] = x[n3] - B[j][k] * x[k];
                ++k;
            }
            int n4 = j;
            x[n4] = x[n4] / B[j][j];
            --j;
        }
        return x;
    }
}

