/*
 * Decompiled with CFR 0.152.
 */
package c41inverter;

import c41inverter.ColorCorrection;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

public class Window {
    private JFrame frame = new Graphicswindow();
    Graphics g;
    Dimension d;
    int w;
    int h;
    int xv;
    int yv;
    private int imgwidth;
    private int imgheight;
    Point mousePos;
    Point selectionRectA;
    Point selectionRectB;
    BufferedImage img = null;
    BufferedImage correctedImage = null;
    boolean redraw = false;
    boolean showOverUnderexposed = false;

    public Window(int psetx, int psety, int psetw, int pseth, String ptitle, MouseListener pmouseListener) {
        this.createFrame(psetx, psety, psetw, pseth, ptitle);
        this.frame.addMouseListener(pmouseListener);
        this.frame.addMouseMotionListener((MouseMotionListener)((Object)pmouseListener));
    }

    public void createFrame(int x, int y, int sx, int sy, String ptitle) {
        this.frame.setTitle(ptitle);
        this.frame.setBounds(x, y, sx, sy);
        this.frame.setDefaultCloseOperation(3);
        this.g = this.frame.getGraphics();
        this.d = this.frame.getSize();
        this.w = this.d.width;
        this.h = this.d.height;
        this.xv = 8;
        this.yv = 30;
        this.frame.setVisible(true);
    }

    public void setImage(BufferedImage pimg) {
        this.img = pimg;
        this.redraw = true;
        this.frame.repaint();
    }

    public Image getImage() {
        return this.img;
    }

    public void applyColorCorrection(ColorCorrection pcc) {
        this.correctedImage = pcc == null ? null : pcc.processImage(this.img, this.showOverUnderexposed);
        this.redraw = true;
        this.frame.repaint();
    }

    public Color getAverageRectColor(Point pa, Point pb) {
        return this.getAverageRectColor(pa, pb, this.img);
    }

    public Color getAverageRectColor(Point pa, Point pb, BufferedImage _image) {
        Point a = new Point(pa);
        Point b = new Point(pb);
        if (pb.getX() < pa.getX()) {
            b.setLocation(pa.getX(), b.getY());
            a.setLocation(pb.getX(), a.getY());
        }
        if (pb.getY() < pa.getY()) {
            b.setLocation(b.getX(), pa.getY());
            a.setLocation(a.getX(), pb.getY());
        }
        if (_image == null) {
            return null;
        }
        int xpos = (int)a.getX() - this.xv;
        int ypos = (int)a.getY() - this.yv;
        double widthscale = (double)_image.getWidth() * 1.0 / (double)this.imgwidth;
        double heightscale = (double)_image.getHeight() * 1.0 / (double)this.imgheight;
        int scaledxpos = (int)((double)xpos * widthscale);
        int scaledypos = (int)((double)ypos * heightscale);
        if (scaledxpos >= _image.getWidth() || scaledypos >= _image.getHeight()) {
            return null;
        }
        int xpos2 = (int)b.getX() - this.xv;
        int ypos2 = (int)b.getY() - this.yv;
        int scaledxpos2 = (int)((double)xpos2 * widthscale);
        int scaledypos2 = (int)((double)ypos2 * heightscale);
        if (scaledxpos2 >= _image.getWidth() || scaledypos2 >= _image.getHeight()) {
            return null;
        }
        double sumR = 0.0;
        double sumG = 0.0;
        double sumB = 0.0;
        int pixelcount = 0;
        int xx = scaledxpos;
        while (xx <= scaledxpos2) {
            int yy = scaledypos;
            while (yy <= scaledypos2) {
                if (xx >= 0 && yy >= 0) {
                    ++pixelcount;
                    Color c = this.getColor(_image, xx, yy);
                    sumR += (double)c.getRed();
                    sumG += (double)c.getGreen();
                    sumB += (double)c.getBlue();
                }
                ++yy;
            }
            ++xx;
        }
        Color c = new Color((int)(sumR / (double)pixelcount), (int)(sumG / (double)pixelcount), (int)(sumB / (double)pixelcount));
        return c;
    }

    public Color getColor(BufferedImage pimg, int x, int y) {
        Color c = new Color(pimg.getRGB(x, y));
        return c;
    }

    public void setMousePos(Point mp) {
        this.mousePos = mp;
        this.frame.repaint();
    }

    public void setSelectionRect(Point pa, Point pb) {
        Point a = pa;
        Point b = pb;
        if (pa != null && pb != null) {
            a = new Point(pa);
            b = new Point(pb);
            if (pb.getX() < pa.getX()) {
                b.setLocation(pa.getX(), b.getY());
                a.setLocation(pb.getX(), a.getY());
            }
            if (pb.getY() < pa.getY()) {
                b.setLocation(b.getX(), pa.getY());
                a.setLocation(a.getX(), pb.getY());
            }
        }
        this.selectionRectA = a;
        this.selectionRectB = b;
        this.frame.repaint();
    }

    public void setOverUnderExposureDisplay(boolean s) {
        this.showOverUnderexposed = s;
        this.redraw = true;
        this.frame.repaint();
    }

    public void wait(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getWindowWidth() {
        return this.frame.getWidth();
    }

    public int getWindowHeight() {
        return this.frame.getHeight();
    }

    class Graphicswindow
    extends JFrame {
        private static final long serialVersionUID = -9056525497877502492L;

        Graphicswindow() {
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getSize();
            int w = d.width;
            int h = d.height;
            if (Window.this.redraw) {
                Color bgcA = new Color(111, 111, 111);
                Color bgcB = new Color(143, 143, 143);
                int _incr = 1;
                int l = 0;
                int i = 0;
                while (i < h) {
                    if (l == 0) {
                        g.setColor(bgcA);
                    } else {
                        g.setColor(bgcB);
                    }
                    g.fillRect(0, i, w, _incr);
                    ++l;
                    l %= 2;
                    i += _incr;
                }
            }
            Window.this.redraw = false;
            if (Window.this.img != null) {
                Window.this.imgwidth = w - Window.this.xv - 8;
                double imagewidthrate = 1.0 * (double)Window.this.imgwidth / (double)Window.this.img.getWidth(this);
                Window.this.imgheight = (int)((double)Window.this.img.getHeight(this) * imagewidthrate);
                if (Window.this.imgheight > h - Window.this.yv - 8) {
                    Window.this.imgheight = h - Window.this.yv - 8;
                    double imageheightrate = 1.0 * (double)Window.this.imgheight / (double)Window.this.img.getHeight(this);
                    Window.this.imgwidth = (int)((double)Window.this.img.getWidth(this) * imageheightrate);
                }
                if (Window.this.correctedImage == null) {
                    g.drawImage(Window.this.img, Window.this.xv, Window.this.yv, Window.this.imgwidth, Window.this.imgheight, this);
                } else {
                    g.drawImage(Window.this.correctedImage, Window.this.xv, Window.this.yv, Window.this.imgwidth, Window.this.imgheight, this);
                }
            }
            if (Window.this.selectionRectA != null && Window.this.selectionRectA != null) {
                int _selectionH;
                Color mpcoloravg = Window.this.getAverageRectColor(Window.this.selectionRectA, Window.this.selectionRectB);
                g.setColor(mpcoloravg);
                int _selectionW = (int)(Window.this.selectionRectA.getX() - Window.this.selectionRectB.getX());
                if (_selectionW < 0) {
                    _selectionW *= -1;
                }
                if ((_selectionH = (int)(Window.this.selectionRectA.getY() - Window.this.selectionRectB.getY())) < 0) {
                    _selectionH *= -1;
                }
                g.fillRect((int)Window.this.selectionRectA.getX(), (int)Window.this.selectionRectA.getY(), _selectionW, _selectionH);
            }
            if (Window.this.mousePos != null) {
                g.setColor(Color.BLACK);
                Color mpcolor = Window.this.correctedImage != null ? Window.this.getAverageRectColor(Window.this.mousePos, Window.this.mousePos, Window.this.correctedImage) : Window.this.getAverageRectColor(Window.this.mousePos, Window.this.mousePos);
                if (mpcolor != null) {
                    g.drawString(String.valueOf(mpcolor.getRed()) + "," + mpcolor.getGreen() + "," + mpcolor.getBlue(), (int)Window.this.mousePos.getX(), (int)Window.this.mousePos.getY());
                }
            }
        }
    }
}

