#!/bin/bash

# create tempdir
TMPDIR=$(mktemp -d)


# some lines of custom config for fisch:
###############  
#CURDIR=$(pwd)
#TMPDIR=$(mktemp -d -p $CURDIR/.tmp)
#mkdir $TMPDIR
###############

# set some vars
OUTDIR="$TMPDIR/out"

# make some dirs
mkdir $OUTDIR > /dev/null

for F in $(ls -A1 | grep ".tif$"); do
  echo "resizing $F ..."
  convert $F -resize 50% -filter Gaussian $TMPDIR/_$F
  echo "inverting $F ..."
