/*
 * Decompiled with CFR 0.152.
 */
package scaninverter;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import scaninverter.ColorPoint;
import scaninverter.Controller;

public class ToolFrame {
    Controller ref_controller;
    private JFrame window;
    private Container contentPane;
    private File global_lastfiledirectory;
    private int colorPointsList_selectedIndex;
    private LinkedList<ColorPoint> ref_colorPoints;
    private ButtonListener buttonListener;
    private JButton b_loadImage;
    private JButton b_addColorPoint;
    private JButton b_removeColorPoint;
    private JButton b_setSelectionColor;
    private JButton b_setCorrectionColor;
    private JButton b_export;
    private JList<String> li_lines;
    DefaultListModel<String> li_linesLM;
    private JCheckBox cb_showProcessed;
    private JCheckBox cb_showOverUnderExposure;
    private JLabel l_exportDecimal;
    private JFormattedTextField tf_exportDecimal;
    private JComboBox cob_Presetlist;
    String[] presets = new String[]{"default"};

    public ToolFrame(int psetx, int psety, int psetw, int pseth, String ptitle, Controller pcontroller, LinkedList<ColorPoint> pcolorPoints, String[] ppresets) {
        this.ref_controller = pcontroller;
        this.window = new JFrame(ptitle);
        this.window.setBounds(psetx, psety, psetw, pseth);
        this.window.setDefaultCloseOperation(3);
        this.contentPane = this.window.getContentPane();
        this.contentPane.setLayout(null);
        this.ref_colorPoints = pcolorPoints;
        this.presets = ppresets;
        this.buttonListener = new ButtonListener();
        this.b_addColorPoint = new JButton("Add");
        this.b_addColorPoint.setBounds(10, 10, 100, 20);
        this.b_addColorPoint.addActionListener(this.buttonListener);
        this.contentPane.add(this.b_addColorPoint);
        this.b_removeColorPoint = new JButton("Remove");
        this.b_removeColorPoint.setBounds(10, 35, 100, 20);
        this.b_removeColorPoint.addActionListener(this.buttonListener);
        this.contentPane.add(this.b_removeColorPoint);
        this.li_linesLM = new DefaultListModel();
        this.li_lines = new JList<String>(this.li_linesLM);
        this.li_lines.setBounds(10, 60, 180, 100);
        this.li_lines.setSelectionMode(1);
        this.li_lines.setLayoutOrientation(0);
        this.li_lines.setSize(120, 150);
        this.contentPane.add(this.li_lines);
        ListSelectionModel li_charlinesSM = this.li_lines.getSelectionModel();
        li_charlinesSM.addListSelectionListener(new colorPointsListSelectionListener());
        JScrollPane li_charlines_listScroller = new JScrollPane(this.li_lines);
        li_charlines_listScroller.setBounds(20, 60, 170, 100);
        this.contentPane.add(li_charlines_listScroller);
        this.b_setSelectionColor = new JButton("Neg. Color");
        this.b_setSelectionColor.setBounds(5, 170, 110, 20);
        this.b_setSelectionColor.addActionListener(this.buttonListener);
        this.contentPane.add(this.b_setSelectionColor);
        this.b_setCorrectionColor = new JButton("Pos. Color");
        this.b_setCorrectionColor.setBounds(120, 170, 110, 20);
        this.b_setCorrectionColor.addActionListener(this.buttonListener);
        this.contentPane.add(this.b_setCorrectionColor);
        this.b_loadImage = new JButton("Load Image");
        this.b_loadImage.setBounds(10, 250, 200, 20);
        this.b_loadImage.addActionListener(this.buttonListener);
        this.contentPane.add(this.b_loadImage);
        this.cb_showProcessed = new JCheckBox("show processed");
        this.cb_showProcessed.setBounds(10, 270, 150, 25);
        this.contentPane.add(this.cb_showProcessed);
        this.cb_showProcessed.setSelected(false);
        this.cb_showProcessed.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("cb_showProcessed=" + ToolFrame.this.cb_showProcessed.isSelected());
                if (ToolFrame.this.cb_showProcessed.isSelected()) {
                    ToolFrame.this.ref_controller.enableColorCorrection();
                } else {
                    ToolFrame.this.ref_controller.disableColorCorrection();
                }
            }
        });
        this.cb_showOverUnderExposure = new JCheckBox("show over/underexposure");
        this.cb_showOverUnderExposure.setBounds(10, 300, 300, 25);
        this.contentPane.add(this.cb_showOverUnderExposure);
        this.cb_showOverUnderExposure.setSelected(false);
        this.cb_showOverUnderExposure.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("cb_showOverUnderExposure=" + ToolFrame.this.cb_showOverUnderExposure.isSelected());
                if (ToolFrame.this.cb_showOverUnderExposure.isSelected()) {
                    ToolFrame.this.ref_controller.enableOverUnderExposureDisplay();
                } else {
                    ToolFrame.this.ref_controller.disableOverUnderExposureDisplay();
                }
                if (ToolFrame.this.cb_showProcessed.isSelected()) {
                    ToolFrame.this.ref_controller.enableColorCorrection();
                } else {
                    ToolFrame.this.ref_controller.disableColorCorrection();
                }
            }
        });
        this.l_exportDecimal = new JLabel("decimals:");
        this.l_exportDecimal.setBounds(30, 325, 80, 25);
        this.contentPane.add(this.l_exportDecimal);
        this.tf_exportDecimal = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.tf_exportDecimal.setValue(new Integer(2));
        this.tf_exportDecimal.setColumns(3);
        this.tf_exportDecimal.setBounds(100, 325, 50, 25);
        this.contentPane.add(this.tf_exportDecimal);
        this.cob_Presetlist = new JComboBox<String>(this.presets);
        this.cob_Presetlist.setSelectedIndex(0);
        this.cob_Presetlist.setBounds(5, 355, 100, 20);
        this.cob_Presetlist.addActionListener(this.buttonListener);
        this.contentPane.add(this.cob_Presetlist);
        this.b_export = new JButton("Export");
        this.b_export.setBounds(120, 355, 100, 20);
        this.b_export.addActionListener(this.buttonListener);
        this.contentPane.add(this.b_export);
        this.updateColorPointsList();
        this.window.setVisible(true);
    }

    public void updateColorPointsList() {
        this.li_linesLM.clear();
        int i = 0;
        while (i < this.ref_colorPoints.size()) {
            ColorPoint cp = this.ref_colorPoints.get(i);
            this.li_linesLM.addElement(cp.toString());
            ++i;
        }
        if (this.cb_showProcessed.isSelected()) {
            this.ref_controller.enableColorCorrection();
        }
    }

    public void deleteSelectedColorPoint() {
        if (this.colorPointsList_selectedIndex >= 0 && this.colorPointsList_selectedIndex < this.ref_colorPoints.size()) {
            this.ref_colorPoints.remove(this.colorPointsList_selectedIndex);
            System.out.println("removed " + this.colorPointsList_selectedIndex);
        }
        this.updateColorPointsList();
    }

    public void addColorPoint() {
        this.ref_colorPoints.add(new ColorPoint());
        System.out.println("added");
        this.updateColorPointsList();
        this.li_lines.setSelectionInterval(this.li_lines.getLastVisibleIndex(), this.li_lines.getLastVisibleIndex());
    }

    public int getExportDecimal() {
        int decimals = -1;
        try {
            decimals = Integer.parseInt(this.tf_exportDecimal.getText());
        }
        catch (Exception e) {
            return -1;
        }
        return decimals;
    }

    public void setPreset(String presetname) {
        this.cob_Presetlist.setSelectedIndex(Arrays.asList(this.presets).indexOf(presetname));
    }

    public int getColorPointsList_selectedIndex() {
        return this.colorPointsList_selectedIndex;
    }

    public void setLastFileDirectory(File plfd) {
        this.global_lastfiledirectory = plfd;
        System.out.println("set global_lastfiledirectory=" + this.global_lastfiledirectory.getAbsolutePath());
    }

    public File getLastFileDirectory() {
        return this.global_lastfiledirectory;
    }

    public String chooseFile(boolean popen) {
        return this.chooseFile(popen, this.global_lastfiledirectory, true);
    }

    public String chooseFileNoSave(boolean popen) {
        return this.chooseFile(popen, this.global_lastfiledirectory, false);
    }

    private String chooseFile(boolean popen, File directory, boolean saveDirectory) {
        String filename = "";
        JFileChooser fc = directory != null ? new JFileChooser(directory) : new JFileChooser();
        int state = popen ? fc.showOpenDialog(null) : fc.showSaveDialog(null);
        if (state == 0) {
            File file = fc.getSelectedFile();
            if (saveDirectory) {
                this.global_lastfiledirectory = file;
                System.out.println("global_lastfiledirectory=" + this.global_lastfiledirectory.getAbsolutePath());
                this.ref_controller.saveConfig();
            }
            filename = file.getAbsolutePath();
        }
        return filename;
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == ToolFrame.this.b_loadImage) {
                System.out.println("b_loadImage");
                String filename = ToolFrame.this.chooseFile(true);
                System.out.println("Selected:" + filename);
                if (filename != "") {
                    ToolFrame.this.ref_controller.loadAsCalibrationimage(filename);
                }
            }
            if (event.getSource() == ToolFrame.this.b_addColorPoint) {
                System.out.println("b_addColorPoint");
                ToolFrame.this.addColorPoint();
            }
            if (event.getSource() == ToolFrame.this.b_removeColorPoint) {
                System.out.println("b_removeColorPoint");
                ToolFrame.this.deleteSelectedColorPoint();
            }
            if (event.getSource() == ToolFrame.this.b_setSelectionColor || event.getSource() == ToolFrame.this.b_setCorrectionColor) {
                System.out.println("b_setSelectionColor");
                ColorPoint _currentColorPoint = (ColorPoint)ToolFrame.this.ref_colorPoints.get(ToolFrame.this.colorPointsList_selectedIndex);
                Color _color = event.getSource() == ToolFrame.this.b_setSelectionColor ? JColorChooser.showDialog(null, "Color Chooser", _currentColorPoint.getSelectedColor()) : JColorChooser.showDialog(null, "Color Chooser", _currentColorPoint.getCorrectedColor());
                if (_color != null) {
                    if (event.getSource() == ToolFrame.this.b_setSelectionColor) {
                        _currentColorPoint.setSelectedColor(_color);
                    } else {
                        _currentColorPoint.setCorrectedColor(_color);
                    }
                    ToolFrame.this.updateColorPointsList();
                } else {
                    System.out.println("no color selected");
                }
            }
            if (event.getSource() == ToolFrame.this.b_export) {
                System.out.println("b_export");
                int _decimals = ToolFrame.this.getExportDecimal();
                if (_decimals >= 0 && _decimals <= 10) {
                    String _filename = ToolFrame.this.chooseFile(false);
                    if (_filename.length() >= 3) {
                        ToolFrame.this.ref_controller.exportCurve(_filename, _decimals);
                    } else {
                        System.out.println("Cancelled");
                    }
                } else {
                    System.err.println("Decimals has to be a number from 0 to 10!");
                }
            }
            if (event.getSource() == ToolFrame.this.cob_Presetlist) {
                int _selectedPreset = ToolFrame.this.cob_Presetlist.getSelectedIndex();
                System.out.println("cob_Presetlist selected=" + _selectedPreset);
                ToolFrame.this.ref_controller.setPreset(ToolFrame.this.presets[_selectedPreset]);
            }
        }
    }

    private class colorPointsListSelectionListener
    implements ListSelectionListener {
        private colorPointsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int firstIndex = e.getFirstIndex();
            int lastIndex = e.getLastIndex();
            boolean isAdjusting = e.getValueIsAdjusting();
            if (lsm.isSelectionEmpty()) {
                System.out.println("selection empty");
            } else {
                int minIndex = lsm.getMinSelectionIndex();
                int maxIndex = lsm.getMaxSelectionIndex();
                System.out.println("Selection min=" + minIndex + " max=" + maxIndex);
                ToolFrame.this.colorPointsList_selectedIndex = minIndex;
            }
        }
    }
}

